/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	SunDisk
**
** DESCRIPTION:	Sun disk puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef SUNDISK_H
#define SUNDISK_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "Puzzle.h"
#include "../Game/GameTimer.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int SunDisk_c_iGhostTime = 2/*10*/ * 60;
const int SunDisk_c_iTimeToNextSunBeam = 3/*20*/ * 60;
const ldwPoint SunDisk_c_sTopLeft(124, 432);
const ldwPoint SunDisk_c_sGhostPos = SunDisk_c_sTopLeft + ldwPoint(50, -35);
const ldwPoint SunDisk_c_sSunBeamPos(0, -200);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CSunDisk : public IPuzzle
{
	friend class CPuzzle;

private:

	//class enumerations
	enum ERef
	{
		eRef_Ghosts = ePuzzle_SunDisk + (1 << 16),
		eRef_SunBeam = ePuzzle_SunDisk + (2 << 16),
		eRef_SunDisk = ePuzzle_SunDisk + (3 << 16)
	};

	enum EState
	{
		eState_Westward = 0,
		eState_Southward,
		eState_Eastward
	};

	//class structures
	struct SSaveState
	{
		EState			m_eState;
		unsigned int	m_uiGhostTime;
		float			m_fGhostAlpha;
	};

	//class data
	EState			m_eState;
	CGameTimer		m_GhostTimer;
	CGameTimer		m_SunBeamTimer;

	bool			m_bIsSunBeamFadingOn;
	bool			m_bIsSunBeamFadingOff;
	float			m_fSunBeamAlpha;
	float			m_fGhostAlpha;

	ldwImage *		m_pSunBeamImage;
	ldwImageGrid *	m_pSunDiskImage;
	ldwImage *		m_pGhosts;

	//class methods
	//setup
	public:		CSunDisk(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;
	public:		void Complete();

	// process
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();

	public:		void Rotate();
	public:		void ShowGhosts();

	// access
	public:		const bool AreGhostsVisible() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CSunDisk		SunDisk;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/